<?php

function setTwoDecimalPoint($value) {
    return number_format(floatval($value), 2, ".", "");
}

function setZeroDecimalPoint($value) {
    return number_format(floatval($value));
}

function location($path) {
    header("Location: " . $path);
    exit;
}

function FETCH_REC($f_flds, $f_tbl, $f_whr = '', $f_ord = '', $f_shoqry = 0) {
    //fetch records of a query (fields,tablename,where and order by)
    global $db;
    $fresarr = $frecarr = array();
    if (!empty($f_whr))
        $f_whr = "WHERE $f_whr";
    if (!empty($f_ord))
        $f_ord = "ORDER BY $f_ord";
    $f_qry = "SELECT $f_flds FROM $f_tbl $f_whr $f_ord";
    if ($f_shoqry > 0)
        echo '<br>' . $f_qry . '<br>';
    $fdbres = $db->query($f_qry);
    if ($db->numRows($fdbres) > 0) {
        while ($fdbrec = $db->fetchNextObject($fdbres)) {
            while (list($fkey, $fval) = each($fdbrec))
                $frecarr[$fkey] = strip_slash($fval);
            $fresarr[] = $frecarr;
        }
    }
    return $fresarr;
}

function FETCH_REC_QUERY($f_qry, $f_shoqry = 0) {
    global $db;
    $fresarr = $frecarr = array();
    if ($f_shoqry > 0)
        echo '<br>' . $f_qry . '<br>';
    $fdbres = $db->query($f_qry);
    if ($db->numRows($fdbres) > 0) {
        while ($fdbrec = $db->fetchNextObject($fdbres)) {
            while (list($fkey, $fval) = each($fdbrec))
                $frecarr[$fkey] = strip_slash($fval);
            $fresarr[] = $frecarr;
        }
    }
    return $fresarr;
}

function INSERT_QUERY($f_tbl, $f_fldvals, $f_excl = array(), $f_stdfld = 1) {
    //insert records
    global $db, $G_curtime;
    $f_fldsfnd = $f_fldsnot = array();
    $f_except = array(); //default fields to be excluded (common for most queries)
    //additional fields to be excluded (based on table)
    reset($f_excl);
    while (list($key, $val) = each($f_excl))
        $f_except[] = $val;

    $fdbres = mysql_query("SELECT * FROM $f_tbl LIMIT 0,1");
    for ($fi = 0; $fi < mysql_num_fields($fdbres); $fi++) {
        $fcurfld = mysql_fetch_field($fdbres, $fi);
        if (!in_array($key, $f_except))
            $f_fldsfnd[$fcurfld->name] = $fcurfld->type;
    }
    if ($f_stdfld == 1) {
        //include common fields
        $f_fldvals['CREATED_BY_DATE'] = time();
    }
    $f_fldvals['LAST_SYNC_TIME'] = 0;
    $fdbsql = 'INSERT INTO ' . $f_tbl . '(';
    $finstr = '';
    reset($f_fldvals);
    while (list($key, $val) = each($f_fldvals)) {
        if (isset($f_fldsfnd[$key])) {
            $fdbsql .= $key . ',';
            $finstr .= "'" . $val . "',";
        } else {
            $f_fldsnot[$key] = $val;
        }
    }
    $fdbsql = substr($fdbsql, 0, strlen($fdbsql) - 1);
    $finstr = substr($finstr, 0, strlen($finstr) - 1);
    $fdbsql .= ') VALUES (' . $finstr . ')';
    $fdbres = $db->execute($fdbsql);
    $f_fldsnot['lastInsertedId'] = ($db->lastInsertedId() > 0) ? $db->lastInsertedId() : 0;
    return $f_fldsnot;
}

function strip_slash($f_dbval) {
    //REMOVE SLASHES BEFORE SPECIAL CHARS
    if (is_array($f_dbval)) {
        //if it's an array
        while (list($key, $value) = each($f_dbval)) {
            $f_dbval[$key] = stripslashes($f_dbval[$key]);
        }
    } else {
        //if it's a variable
        $f_dbval = stripslashes($f_dbval);
    }
    return $f_dbval;
}

/* ========== START - ARRAY SERACH FUNCTION (MULTI DIMENTION ARRAY) ========= */

function findArrByFieldValue($products, $field, $value) {
    foreach ($products as $key => $product) {
        if ($product[$field] === $value)
            return $key;
    }
    return false;
}

/* ========== END - ARRAY SERACH FUNCTION (MULTI DIMENTION ARRAY) ========= */

function objectToArray($d) {
    if (is_object($d)) {
        // Gets the properties of the given object
        // with get_object_vars function
        $d = get_object_vars($d);
    }
    if (is_array($d)) {
        /*
         * Return array converted to object
         * Using __FUNCTION__ (Magic constant)
         * for recursive call
         */
        return array_map(__FUNCTION__, $d);
    } else {
        // Return array
        return $d;
    }
}
function UPDATE_QUERY($f_tbl, $f_fldvals, $f_whr = '', $f_excl = array(), $f_stdfld = 0) {
    //update records
    global $db, $G_curtime;
    $affectRows = "";
    $f_fldsfnd = $f_fldsnot = array();
    $f_except = array(); //default fields to be excluded (common for most queries)
    //additional fields to be excluded (based on table)
    reset($f_excl);
    while (list($key, $val) = each($f_excl))
        $f_except[] = $val;
    $fdbres = mysql_query("SELECT * FROM $f_tbl LIMIT 0,1");
    for ($fi = 0; $fi < mysql_num_fields($fdbres); $fi++) {
        $fcurfld = mysql_fetch_field($fdbres, $fi);
        if (!in_array($key, $f_except))
            $f_fldsfnd[$fcurfld->name] = $fcurfld->type;
    }
    if ($f_stdfld == 1) {
        $f_fldvals['CHANGED_BY_DATE'] = time();
    }
    $fdbsql = 'UPDATE ' . $f_tbl . ' SET ';
    reset($f_fldvals);
    while (list($key, $val) = each($f_fldvals)) {
        if (isset($f_fldsfnd[$key]))
            $fdbsql .= "$key='" . $val . "',";
        else
            $f_fldsnot[$key] = $val;
    }
    $fdbsql = substr($fdbsql, 0, strlen($fdbsql) - 1);
    $fdbsql .= (!empty($f_whr)) ? " WHERE $f_whr" : '';
    $fdbres = $db->query($fdbsql);
    //$affectRows = mysql_affected_rows();
    return ($affectRows > 0) ? $affectRows : 0;
}

function DELETE_QUERY($f_tbl, $f_whr = '') {
    //delete records
    global $db;
    if (!empty($f_whr))
        $f_whr = "WHERE $f_whr";
    $f_qry = "DELETE FROM $f_tbl $f_whr";
    $fdbres = $db->query($f_qry);
    return (mysql_affected_rows() > 0) ? mysql_affected_rows() : 0;
}

function createArray($tableName, $arrForLoop) {
    $tmpArr = $finalArr = array();
    $tmpArr['tableName'] = $tableName;
    if (count($arrForLoop) > 0) {
        for ($i = 0; $i < count($arrForLoop); $i++) {
            $tmpArr[] = $arrForLoop[$i];
        }
    } else {
        $tmpArr[] = array();
    }
    return $tmpArr;
}

/* takes the input, scrubs bad characters */

function replaceComma($str) {
    return str_replace('"', "'", $str);
    // return str_replace('"', '*#@', $str);
}

function unReplaceComma($str) {
    return str_replace('*#@', '"', $str);
}
?>
