<?php

session_start();
date_default_timezone_set('Asia/Kolkata');
ini_set("display_errors", 1);
//define("APIURL", 'http://localhost/umiyawatersupply/api/commonApi.php');
define("APIURL", 'http://www.maruunjha.com/umiya/api/commonApi.php');
define("SCS", 'Success');
$userId = '1';

function postCurlCall($url, $post) {
    $ch = curl_init($url);
# Form data string
    $data['post'] = $post;
    $postString = http_build_query($data, '', '&');
# Setting our options
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postString);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
# Get the response
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

class Encryption {
    var $skey = "appsaraahmedabad"; // you can change it

    public  function safe_b64encode($string) {
        $data = base64_encode($string);
        $data = str_replace(array('+','/','='),array('-','_',''),$data);
        return $data;
    }

    public function safe_b64decode($string) {
        $data = str_replace(array('-','_'),array('+','/'),$string);
        $mod4 = strlen($data) % 4;
        if ($mod4) {
            $data .= substr('====', $mod4);
        }
        return base64_decode($data);
    }

    public  function encode($value){ 
        if(!$value){return false;}
        $text = $value;
        $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
        $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
        $crypttext = mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $this->skey, $text, MCRYPT_MODE_ECB, $iv);
        return trim($this->safe_b64encode($crypttext)); 
    }

    public function decode($value){
        if(!$value){return false;}
        $crypttext = $this->safe_b64decode($value); 
        $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
        $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
        $decrypttext = mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $this->skey, $crypttext, MCRYPT_MODE_ECB, $iv);
        return trim($decrypttext);
    }
}


function getLogin($userId,$userName,$password) {
    $post = array(
        "requestCase" => 'getLogin',
        "userName" => $userName,
        "password" => $password,
        "userId" => $userId
    );

    $response = postCurlCall(APIURL, $post);
    return $response;
}

function getCustomerList($userId) {
    $post = array(
        "requestCase" => 'getCustomerList',
        "userId" => $userId
    );

    $response = postCurlCall(APIURL, $post);
    return $response;
}
function generateBill($clientId,$userId,$customerId,$netAmt,$productArr,$billingDate) {
    $post = array(
        "requestCase" => 'generateBill',
        "userId" => $userId,
        "clientId" => $clientId,
        "customerId" => $customerId,
        "total_amount" => $netAmt,
        "billingDate" => $billingDate,
        "productArr" => $productArr
    );

    $response = postCurlCall(APIURL, $post);
    return $response;
}

function getProductList($userId) {
    $post = array(
        "requestCase" => 'getProductList',
        "userId" => $userId
    );

    $response = postCurlCall(APIURL, $post);
    return $response;
}

function getCityList($userId) {
    $post = array(
        "requestCase" => 'getCityList',
        "userId" => $userId
    );

    $response = postCurlCall(APIURL, $post);
    return $response;
}

function getBillList($userId) {
    $post = array(
        "requestCase" => 'getBillList',
        "userId" => $userId
    );

    $response = postCurlCall(APIURL, $post);
    return $response;
}

function getBillLDetails($userId,$billId) {
    $post = array(
        "requestCase" => 'getBillLDetails',
        "userId" => $userId,
        "billId" => $billId
    );

    $response = postCurlCall(APIURL, $post);
    return $response;
}

function deleteCustomer($userId,$customerId) {
    $post = array(
        "requestCase" => 'deleteCustomer',
        "userId" => $userId,
        "customerId" => $customerId
    );

    $response = postCurlCall(APIURL, $post);
    return $response;
}

function deleteBill($userId,$billId) {
    $post = array(
        "requestCase" => 'deleteBill',
        "userId" => $userId,
        "billId" => $billId
    );

    $response = postCurlCall(APIURL, $post);
    return $response;
}

function addEditCustomer($userId,$customerId,$requestCase,$customerName,$customerMobile,$customerEmail,$customerAddress,$customerCity) {
    $post = array(
        "requestCase" => $requestCase,
        "customer_name" => $customerName,
        "customer_number" => $customerMobile,
        "customer_email" => $customerEmail,
        "customer_address" => $customerAddress,
        "cityId" => $customerCity,
        "customerId" => $customerId,
        "userId" => $userId
    );

    $response = postCurlCall(APIURL, $post);
    return $response;
}

function submitInquiry($userId,$name,$mobile,$email,$productId) {
    $post = array(
        "requestCase" => 'submitInquiry',
        "userId" => $userId,
        "name" => $name,
        "mobile" => $mobile,
        "productId" => $productId,
        "email" => $email
    );

    $response = postCurlCall(APIURL, $post);
    return $response;
}
function some_function($string,$count){
     $string = substr($string,0,$count);
     $string = substr($string,0,strrpos($string," "));
     return $string;
}
?>