<?php

header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: POST,GET,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

ini_set("display_errors", 1);

require_once "class_db.php"; // DB CLASS FILE
require_once "constant.php"; // CONSTANT FILE
require_once "connection.php"; // CONNECTION FILE
require_once "function.php"; // COMMON FUNCTIONS FILE
require_once "commonApiData.php"; // API FUNCTION FILE

$post = isset($_REQUEST) ? $_REQUEST : "";
$postFile = '';

$requestCase = isset($post['post']['requestCase']) ? $post['post']['requestCase'] : "";

if ($requestCase != '' && !empty($post)) {
    switch ($requestCase) {
        case "getCityList":  
            $result = getCityList($post);
            $jsonData = json_encode($result);
            break;
        case "getCustomerList":  
            $result = getCustomerList($post);
            $jsonData = json_encode($result);
            break;
        case "deleteCustomer":  
            $result = deleteCustomer($post);
            $jsonData = json_encode($result);
            break;
        case "getLogin":  
            $result = getLogin($post);
            $jsonData = json_encode($result);
            break;
        case "getProductList":  
            $result = getProductList($post);
            $jsonData = json_encode($result);
            break;
        case "getBillList":  
            $result = getBillList($post);
            $jsonData = json_encode($result);
            break;
        case "addEditCustomer":  
            $result = addEditCustomer($post);
            $jsonData = json_encode($result);
            break;
        case "generateBill":  
            $result = generateBill($post);
            $jsonData = json_encode($result);
            break;
        case "getBillLDetails":  
            $result = getBillLDetails($post);
            $jsonData = json_encode($result);
            break;
        case "deleteBill":  
            $result = deleteBill($post);
            $jsonData = json_encode($result);
            break;
        
        
    }
}else{
    $result = array();
    $jsonData = json_encode($result);
}
if ($jsonData) {
    echo $jsonData;
} else {
    $result = array('status' => FAIL);
    echo json_encode($result);
}
?>